/*----------------------------------------------------------------------------
 *  Organization:  Copyright © 2021 NST, LTD. all rights reserved.
 *----------------------------------------------------------------------------*/

#include "common_function.h"

int32_t main(int32_t argc, char** argv)
{
    printf("The version of SDK is %s\n", moGetSdkVersion());

    MO_CAMERA_HANDLE hCameraHandle = MO_INVALID_HANDLE;

    BEGIN_TO_WORK(argc, argv[1])

    /**< 1. Open specific camera */
    s32Result = moOpenUVCCameraByPath(caCameraPath, &hCameraHandle);
    BREAK_INFO_PRINT(s32Result, moOpenUVCCameraByPath)

    /**< 2. Set fill light type */
    s32Result = moSetFilllightType(hCameraHandle, MFT_ON);
    BREAK_INFO_PRINT(s32Result, moSetFilllightType)

    /**< 3. Get fill light type */
    mo_filllight_type eFilllightType = MFT_OFF;
    s32Result = moGetFilllightType(hCameraHandle, &eFilllightType);
    BREAK_INFO_PRINT(s32Result, moGetFilllightType)

    if ((     0 == s32Result)    &&
        (MFT_ON != eFilllightType))
    {
        printf("??? Get %d didn't equal %d then moS/GetFilllightType which have a problem ???\n",
               eFilllightType, MFT_ON);
    }

    END_TO_WORK

    /**< 4. Close specific camera */
    moCloseCamera(&hCameraHandle);

    return s32Result;
}
