/*----------------------------------------------------------------------------
 *  Organization:  Copyright © 2021 NST, LTD. all rights reserved.
 *----------------------------------------------------------------------------*/

#include "common_function.h"

// Enable WANNA_USE_OPENCV define in CMakelist.txt
#ifdef WANNA_USE_OPENCV
    #include "opencv2/opencv.hpp"
    using namespace cv;
    using namespace std;
#endif // WANNA_USE_OPENCV

#define video_frame_width  1280
#define video_frame_height 720

int32_t main(int32_t argc, char** argv)
{
    printf("The version of SDK is %s\n", moGetSdkVersion());

    MO_CAMERA_HANDLE hCameraHandle = MO_INVALID_HANDLE;

    BEGIN_TO_WORK(argc, argv[1])

    /**< 1. Open specific camera */
    s32Result = moOpenUVCCameraByPath(caCameraPath, &hCameraHandle);
    BREAK_INFO_PRINT(s32Result, moOpenUVCCameraByPath)

    uint64_t      u64ImageFrameNum            = 0;
    uint8_t*      pu8FrameBuffer              = NULL;
    uint8_t*      pu8OnlyY                    = NULL;
    uint8_t*      pu8RectifiedRightYUVI420Img = NULL;
    double        d8FPS                       = 0.0f;
    char          caFPS[24]                   = {0};
    mo_video_mode eVideoMode                  = MVM_RECTIFIED;

    /**< 2. get current video mode */
    s32Result = moGetVideoMode(hCameraHandle, &eVideoMode);
    BREAK_INFO_PRINT(s32Result, moGetVideoMode)

    /**< 3. set RECTIFIED mode : frame = Gray(Only Y) + YUV_I420 */
    if (MVM_RECTIFIED != eVideoMode) {
        s32Result = moSetVideoMode(hCameraHandle, MVM_RECTIFIED);
        BREAK_INFO_PRINT(s32Result, moSetVideoMode)
    }

    BEGIN_GET_VIDEO_FRAME_LOOP

    /**< 4. get current video frame */
    s32Result = moGetCurrentFrame(hCameraHandle, &u64ImageFrameNum, &pu8FrameBuffer);
    BREAK_INFO_PRINT(s32Result, moGetCurrentFrame)

    /**< 5. get real-time FPS */
    s32Result = moGetRealTimeFPS(hCameraHandle, &d8FPS);

    // Failed to get FPS(usually caused by insufficient frame counts during initial period)
    if (0 != s32Result) {
        printf("moGetRealTimeFPS fails, return %d\n", s32Result);
        strcpy(caFPS, "FPS: being counted");
        printf("FN: %lu FB: %p %s\n", u64ImageFrameNum, pu8FrameBuffer, caFPS);
    } else {
        sprintf(caFPS, "FPS: %f", d8FPS);
        printf("FN: %lu FB: %p %s\n", u64ImageFrameNum, pu8FrameBuffer, caFPS);
    }

    /**< 6. get left and right image */
    s32Result = moGetRectifiedImage(hCameraHandle, pu8FrameBuffer, &pu8OnlyY, &pu8RectifiedRightYUVI420Img);
    BREAK_INFO_PRINT(s32Result, moGetRectifiedImage)

    #ifdef WANNA_USE_OPENCV
    waitKey(FETCH_AND_DISPLAY_TIME_LENGTH);
    Mat matLeftBGR;
    Mat matLeftRectify(video_frame_height, video_frame_width, CV_8UC1, pu8OnlyY);
    cvtColor(matLeftRectify, matLeftBGR, COLOR_GRAY2BGR);
    // Mark fps at top left corner
    putText(matLeftBGR, string(caFPS), Point(50, 60), FONT_HERSHEY_COMPLEX, 1, Scalar(255, 0, 0));
    imshow("LeftRectify", matLeftBGR);

    Mat matRightBGR; // 1.5 = 12bits / 8bits
    Mat matRightRectify(video_frame_height * 1.5, video_frame_width, CV_8UC1, pu8RectifiedRightYUVI420Img);
    cvtColor(matRightRectify, matRightBGR, COLOR_YUV2BGR_I420);
    // Mark fps at top left corner
    putText(matRightBGR, string(caFPS), Point(50, 60), FONT_HERSHEY_COMPLEX, 1, Scalar(255, 0, 0));
    imshow("RightRectify", matRightBGR);
    #endif // WANNA_USE_OPENCV

    END_GET_VIDEO_FRAME_LOOP
    END_TO_WORK

    /**< 7. Close specific camera */
    moCloseCamera(&hCameraHandle);

    return s32Result;
}
