/*----------------------------------------------------------------------------
 *  Organization:  Copyright © 2021 NST, LTD. all rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef MO_STEREO_CAMERA_DRIVER_TYPE_DEFINE_INCLUDED
    #define MO_STEREO_CAMERA_DRIVER_TYPE_DEFINE_INCLUDED

    #include <stdlib.h>
    #include <string.h>
    #include <inttypes.h>

    /**< enum define area */
    typedef enum _mo_camera_type_e
    {
        MCT_UVC      = 0, // UVC  camera
        MCT_MIPI     = 1, // MIPI camera
        MCT_ETHERNET = 2  // Ethernet camera
    }mo_camera_type;

    typedef enum _mo_filllight_type_e
    {
        MFT_OFF                = 0, // Fill light off
        MFT_ON                 = 1, // Fill light on
        MFT_EXPOSURE_SYNC      = 2, // Fill light synchronizes with exposure
        MFT_ON_OFF_ALTERNATION = 3  // Fill light alternates between on and off
    }mo_filllight_type;

    typedef enum _mo_video_mode_e
    {
        MVM_RAW       = 0, // Bayer        + Bayer
        MVM_RECTIFIED = 2, // Gray(Only Y) + YUV_I420
        MVM_RGBD      = 5  // Disparity    + YUV_I420
    }mo_video_mode;

    typedef enum _mo_video_resolution_e
    {
        MVR_HDWXGA = 0 // 1280 * 720
    }mo_video_resolution;

    /**< struct define area */
    typedef struct _mo_video_frame_param_s
    {
        mo_video_resolution eVideoResolution; // Supported video resolution
        uint8_t             u8FrameRate;      // Supported video frame rate
    }mo_video_frame_param;

    typedef struct _mo_camera_info_node_s
    {
        mo_camera_type          eCameraType;
        char                    caSN[24];         // e.g. "2021072318520001"
        char                    caFriendName[32]; // e.g. NST Depth Camera 5504k
        char                    caAddress[16];    // e.g. /dev/video0 or 192.168.0.168
        _mo_camera_info_node_s* pstPrevNode;
        _mo_camera_info_node_s* pstNextNode;
    }mo_camera_info_node;

    typedef struct _mo_imu_data_s
    {
        uint64_t u64ImageFrameNum;
        uint64_t u64Timestamp;

        double   dTemperature;

        double   dAccelX;
        double   dAccelY;
        double   dAccelZ;

        double   dGyroX;
        double   dGyroY;
        double   dGyroZ;
    }mo_imu_data;

    typedef struct _mo_rect_distance_info_s
    {
        struct _in_param_s
        {
            // Input Parameter
            // Region of interest described by rectangle with coordinate of top-left corner and width and height.
            uint16_t u16LeftTopCornerX; // X coordinate of the top-left corner
            uint16_t u16LeftTopCornerY; // Y coordinate of the top-left corner
            uint16_t u16RectWidth;      // Width  of the rectangle
            uint16_t u16RectHeight;     // Height of the rectangle

            // Buffer pointer to disparity data(obtained from moGetRGBDImage / moGetRGBDDisparityData function)
            uint16_t* pu16RGBDDisparityData;
        }stInParam;

        struct _out_param_s
        {
            // Output Parameter
            uint16_t u16MinimumDisparity; // minimum disparity in region of interest
            uint16_t u16MaximumDisparity; // maximum disparity in region of interest
            uint16_t u16MeanDisparity;    // mean    disparity in region of interest
            uint16_t u16MedianDisparity;  // median  disparity in region of interest

            float    fDisparityDensity;   // disparity density in region of interest

            float    fMinimumDepth;       // minimum depth in region of interest
            float    fMaximumDepth;       // maximum depth in region of interest
            float    fMeanDepth;          // mean    depth in region of interest
            float    fMedianDepth;        // median  depth in region of interest

            float    fMeanDistance;       // mean   distance in region of interest
            float    fMedianDistance;     // median distance in region of interest
        }stOutParam;
    }mo_rect_distance_info;

#endif // MO_STEREO_CAMERA_DRIVER_TYPE_DEFINE_INCLUDED
